def dijkstra(graph,start,dest,visited=[],distances={},predecessors={}):
    """ calculates a shortest path in the graph from start to dest
    """    
    # a few basic checks
    if start not in graph:
        raise TypeError('The start vertex is not in the graph')
    if dest not in graph:
        raise TypeError('The destination vertex is not in the graph')    


    # ending condition - base case
    if start == dest:
        # We build the shortest path and display it
        path=[]
        pred=dest
        while pred != None:
            path.append(pred)
            pred=predecessors.get(pred,None)
        print('shortest path: '+str(path)+" cost="+str(distances[dest])) 


    else :     
        # if it is the initial  run, initializes the cost
        if not visited: 
            distances[start]=0

        # visit the neighbors
        for neighbor in graph[start] :
            if neighbor not in visited:
                new_distance = distances[start] + graph[start][neighbor]
                if new_distance < distances.get(neighbor,float('inf')):
                    distances[neighbor] = new_distance
                    predecessors[neighbor] = start

        # mark as visited
        visited.append(start)

        # now that all neighbors have been visited: recurse                         
        # select the non visited node with lowest distance 'x'
        # run Dijskstra with start='x'
        unvisited={}
        for k in graph:
            if k not in visited:
                unvisited[k] = distances.get(k,float('inf'))        
        x=min(unvisited, key=unvisited.get)
        dijkstra(graph,x,dest,visited,distances,predecessors)
        



graph = {'s': {'a': 2, 'b': 1},'a': {'s': 3, 'b': 4, 'c':8},'b': {'s': 4, 'a': 2, 'd': 2},'c': {'a': 2, 'd': 7, 't': 4},'d': {'b': 1, 'c': 11, 't': 5},'t': {'c': 3, 'd': 5}}

dijkstra(graph,'bob','t')
