# 20Q Complete Program
# --------------------
# Simple 20 question game. This versions is about animals.
# 
# This is the outline

import random
from Animal import Animal
from Mammal import Mammal
from MarineMammal import MarineMammal
from Bird import Bird
from Flightless import Flightless
from MarineBird import MarineBird
from Fish import Fish


# Create a set of Animals - each has a name and attributes
def animals():
    animals = []
    animals.append(Bird("Parrot","Small",False,False,True))
    animals.append(Bird("Vulture","Small",True,False,False))
    animals.append(MarineBird("Penguin","Small",True,False,True))
    animals.append(Flightless("Emu","Large",False,False,True))
    animals.append(Fish("Shark","Large",True,True,True))
    animals.append(Fish("Carp","Small",False,False,False))
    animals.append(Fish("Cod","Small",True,False,False))
    animals.append(Fish("Minnow","Tiny",False,False,False))
    animals.append(Mammal("Horse",4,"Large",False,False,False))
    animals.append(Mammal("Zebra",4,"Large",False,False,True))
    animals.append(Mammal("Badger",4,"Small",True,False,False))
    animals.append(Mammal("Bear",4,"Large",True,False,True))
    animals.append(Mammal("Tiger",4,"Large",True,True,True))
    animals.append(Mammal("Elephant",4,"Huge",False,False,True))
    animals.append(MarineMammal("Dolphin","Large",True,False,True))
    animals.append(MarineMammal("Killerwhale","Huge",True,True,True))
    return animals

# This is a list of questions
questions = [
    "Does it fly",                # 1
    "Does it swim?",               # 2
    "Does it lay eggs?",          # 3
    "Has it got feathers?",        # 4
    "Has it got fur?",             # 5
    "Has it got legs?",            # 6
    "Has it got 4 legs?",          # 7
    "Is it smaller than a mouse?", # 8
    "Is it as large as a sheep?",  # 9
    "Is it larger than a car?",    # 10
    "Does it eat meat?",           # 11
    "Might it sting or bite you?", # 12
    "Do you visit it at the zoo?"  # 13
    ]
   
# This function answer each qustion for each animal
# The answer use only the interface of th Animal class
#   - the methods overriden in subclasses of Animal
#   - the attribute values given when each Animal created
def answerQuestion(animal, qNum):
    if qNum == 1:
        return animal.canFly()
    elif qNum == 2:
        return animal.canSwim()
    elif qNum == 3:
        return animal.layEggs()
    elif qNum == 4:
        return animal.hasFeathers()
    elif qNum == 5:
        return animal.hasFur()
    elif qNum == 6:
        return animal.getLegs() > 0
    elif qNum == 7:
        return animal.getLegs() == 4
    elif qNum == 8:
        return animal.getSize() == "Tiny"
    elif qNum == 9:
        c1 = animal.getSize() == "Large"
        c2 = animal.getSize() == "Huge"
        return c1 or c2
    elif qNum == 10:
        return animal.getSize() == "Huge"
    elif qNum == 11:
        return animal.getMeat()
    elif qNum == 12:
        return animal.getStings()
    elif qNum == 13:
        return animal.getZoo()
    else:
        pass


# Print out the questions with a number
def listQuestions():
    count = 0
    for q in questions:
        count = count + 1
        print("   "+ str(count) +"):",q)
    return count 

# List the Animals by name
def listAnimals(als):
    for a in als:
        print("  ", a.getName())

# -----------------------------------
# Main Progam - User Interfae
#   * List the animals
#   * List the questions
#   * Prompt user to choose N questions
#   * check not the same question and in range 
#   * ... answer each question
#   * Get the user's guess and reveal answer
# The UI should be independent of the choose of area 
#   - Animals, Sports, etc.
# This has not quite been achieved - can you see why?
# -----------------------------------
allAnimals = animals()
answered = set()

GOES = 5
secret = random.choice(allAnimals)
#print("----Cheating-----")
#print(secret.getName())
#print("----End-----\n")

print("I have chosen one of the following animals")
listAnimals(allAnimals)

go = 0
print("The questions are:")
qcount = listQuestions()
while go < GOES:
    print("You have", str(GOES-go), "more questions")
    choice = int(input("   Please pick a question: "))
    if (choice in answered) or (choice not in range(1,qcount+1)):
        print("   Thats wrong! Choose again")
    else:
        print("   You asked:", questions[choice-1])
        print("   The answer is: ", answerQuestion(secret, choice))
        answered = answered | {choice}
        go = go + 1

print("Now you must guess the animal")
name = input(" Enter the name of you guess: ")

if name == secret.getName():
    print("Well done. Good guess")
else:
    print("Bad luck. I was thinking of a", secret.getName())

print(secret.getDescription())


