# This is the top class
class Animal:

    def __init__(self, name, legs, size, meat):
        self.name = name
        self.legs = legs
        self.size = size
        self.meat = meat 

    def getName(self): return self.name            

    # These methods access the attributes
    # Different Animals have different attribute values 
    def getLegs(self): return self.legs
    def getSize(self): return self.size
    def getMeat(self): return self.meat

    # These methods are implemented but may be overidden  
    def hasFur(self): return False
    def canSwim(self): return False


    # EXERCISE 2: this method is inherited by subclasses
    #   Note that the version of the canSwim and hasFur method used
    #   Depends on the (sub)class of the object  
    def getDescription(self):
        s = "The " + self.name + " has the following characteristics:\n"
        s = s + ("  It can swim" if self.canSwim() else "  It cannot swim")
        s = s + ("; it has" if self.hasFur() else "; it does not have") + " fur\n"
        s = s + "  It has " + str(self.legs) + " legs"
        s = s + "; it is " + self.size
        s = s + ("; it eats meat" if self.meat else "; does not eat meat")
        return s

