# 20Q Complete Program
# --------------------
# Simple 20 question game. This versions is about animals.
# 
# This is the outline

import random
from Animal import Animal
from Mammal import Mammal
from MarineMammal import MarineMammal

# Create a set of Animals - each has a name and attributes
def animals():
    animals = []
    animals.append(Mammal("Horse",4,"Large",False))
    animals.append(Mammal("Badger",4,"Small",True))
    animals.append(Mammal("Tiger",4,"Large",True))
    animals.append(Mammal("Elephant",4,"Huge",False))
    animals.append(MarineMammal("Dolphin","Large",True))
    animals.append(MarineMammal("Killerwhale","Huge",True))
    return animals

# This is a list of questions
questions = [
    "Does it swim?",               # 1
    "Has it got fur?",             # 2
    "Has it got legs?",            # 3
    "Has it got 4 legs?",          # 4
    "Is it smaller than a mouse?", # 5
    "Is it as large as a sheep?",  # 6
    "Is it larger than a car?",    # 7
    "Does it eat meat?",           # 8
    ]
   
# This function answer each qustion for each animal
# The answer use only the interface of th Animal class
#   - the methods overriden in subclasses of Animal
#   - the attribute values given when each Animal created
def answerQuestion(animal, qNum):
    if qNum == 1:
        return animal.canSwim()
    elif qNum == 2:
        return animal.hasFur()
    elif qNum == 3:
        return animal.getLegs() > 0
    elif qNum == 4:
        return animal.getLegs() == 4
    elif qNum == 5:
        return animal.getSize() == "Tiny"
    elif qNum == 6:
        c1 = animal.getSize() == "Large"
        c2 = animal.getSize() == "Huge"
        return c1 or c2
    elif qNum == 7:
        return animal.getSize() == "Huge"
    elif qNum == 8:
        return animal.getMeat()
    else:
        pass

# Print out the questions with a number
def listQuestions():
    count = 1
    for q in questions:
        print("   "+ str(count) +"):",q)
        count = count + 1

# List the Animals by name
def listAnimals(als):
    for a in als:
        print("  ", a.getName())

# -----------------------------------
# Main Progam - User Interfae
#   * List the animals
#   * List the questions
#   * Prompt user to choose N questions
#   * check not the same question and in range 
#   * ... answer each question
#   * Get the user's guess and reveal answer
# The UI should be independent of the choose of area 
#   - Animals, Sports, etc.
# This has not quite been achieved - can you see why?
# -----------------------------------
allAnimals = animals()
answered = set()

secret = random.choice(allAnimals)
#print("----Cheating-----")
#print(secret.getName())
#print("----End-----\n")

print("I have chosen one of the following animals")
listAnimals(allAnimals)

go = 0
print("The questions are:")
listQuestions()
while go < 3:
    print("You have", str(3-go), "more questions")
    choice = int(input("   Please pick a question: "))
    if (choice in answered) or (choice not in range(1,9)):
        print("   Thats wrong! Choose again")
    else:
        print("   You asked:", questions[choice-1])
        print("   The answer is: ", answerQuestion(secret, choice))
        answered = answered | {choice}
        go = go + 1

print("Now you must guess the animal")
name = input(" Enter the name of you guess: ")

if name == secret.getName():
    print("Well done. Good guess")
else:
    print("Bad luck. I was thinking of a", secret.getName())

print(secret.getDescription())


