from Form import Form
from Teacher import Teacher

def getTextInput(prompt, values):
    ans = input(prompt).upper()
    while ans not in values:
        ans = input(prompt).upper()
    return ans

def getIntInput(prompt, values):
    ans = int(input(prompt))
    while ans not in values:
        ans = int(input(prompt))
    return ans

def selectForm(forms):
    print("Choose form")
    c = 1
    for f in forms:
        print("  ", c, f.getTeacher().getName())
        c = c + 1
    fnum = getIntInput("Enter number> ", range(1, c))
    return forms[fnum-1]

def updateAge(f):
    pname = input("  Pupil to find> ")
    p = f.findPupil(pname)
    if p != None:
        print(p.getDetails())
        age = input("Enter age> ")
        p.setAge(int(age))
    else:
        print(pname, "not found")

t1 = Teacher("Mr Smith")
year1 = Form(t1)
t2 = Teacher("Mrs Brown")
year2 = Form(t2)
forms = [year1, year2]

while True:
    f = selectForm(forms)
    action = getTextInput("Enter actions: [A]dd pupil, [L]ist, [U]pdate> ", \
                          ['A', 'L', 'U'])
    if action == 'A':
        f.addNewPupil()
    elif action == 'L':
        print(f.listRoll())
    elif action == 'U':
        updateAge(f)


        
