from Pupil import Pupil

# A Form has teacher, a room number and a
# list of pupils 

class Form:

    # The room is not always known. There are no
    # pupils at first
    def __init__(self, teacher):
        self.teacher = teacher
        self.room = None
        self.pupils = []

    def getTeacher(self):
        return self.teacher
        
    # An existing pupil is added to the form
    def addPupil(self, p):
        self.pupils.append(p)

    # Create a new pupil and add to the form
    def addNewPupil(self):
        pName = input("Pupil name> ")
        if len(pName) == 0:
            return
        p = Pupil(pName)
        pAge = input("Pupil age (or RTN)> ")
        if len(pAge) > 0:
            p.setAge(int(pAge))
        self.addPupil(p)

    # List pupils in the form
    def listRoll(self):
        fl = self.teacher.getName() + "'s form"
        if self.room != None:
            fl = fl + " in room " + self.room
        fl = fl + "\n"
        for p in self.pupils:
            fl = fl + "  " + p.getDetails() + "\n"
        return fl

    # Find a pupil by name
    def findPupil(self, name):
        for p in self.pupils:
            if p.getName() == name:
                return p
        return None

            

