
# Functions for playing noughts and crosses.
#   No AI: there a two human players

chrV = {" ":0, "X":1, "O":-1}

# Ask who starts. Return true if X
def askWhoStarts():
    xoro = " "
    while xoro not in ["X", "O"]:
        xoro = input("Choose player to start [X/O]> ")
    return xoro == "X"

# Return an empty board
def createBoard():
    return [" "," "," "," "," "," "," "," "," "]

# Print the current board
def printBoard(b):
    print(b[0]+"|"+b[1]+"|"+b[2])
    print("-----")
    print(b[3]+"|"+b[4]+"|"+b[5])
    print("-----")
    print(b[6]+"|"+b[7]+"|"+b[8])

# Get the play position for
def getPlayPos(isXNext):
    if isXNext:
        print("X to play:")
    else:
        print("O to play:")
    x = input("Enter row [0,1,2]> ")  
    while x not in ['0', '1', '2']:
        x = input("Enter row [0,1,2]> ")
    y = input("Enter column [0,1,2]> ")
    while y not in ['0', '1', '2']:
        y = input("Enter column [0,1,2]> ")
    return (int(x),int(y))
    
# Check if the move is valid at the given position
def isValid(pos, b):
    x,y = pos
    return b[y+3*x] == " "

# Get and check play position
def getValidPos(isXNext, b):
    pos = getPlayPos(isXNext)
    while not isValid(pos, b):
        print("That square is already taken")
        pos = getPlayPos(isXNext)
    return pos


# Update the board at the given position 
def updateBoard(b, pos, isXNext):
    char = "O"
    if isXNext: char = "X"
    x,y = pos
    b[y+3*x] = char    

# Check if there is a line
def hasLine(b):
    l = False
    for i in [0,1,2]:
        l = l or (sum([chrV[b[i]],chrV[b[i+1]],chrV[b[i+2]]]) in [-3, 3])
        l = l or (sum([chrV[b[i]],chrV[b[i+3]],chrV[b[i+6]]]) in [-3, 3])
    l = l or (sum([chrV[b[0]],chrV[b[4]],chrV[b[8]]]) in [-3, 3])
    l = l or (sum([chrV[b[2]],chrV[b[4]],chrV[b[6]]]) in [-3, 3])    
    return l

# Print the message for the winner
def printWinMsg(isXNext):
    char = "O"
    if isXNext: char = "X"
    print("Well done", char, "you have won!")

# Check if the board is full
def boardFull(b):
    return " " not in b

# Check if game is over - print message
def checkFinished(b, isXNext):
    if hasLine(b):
        printWinMsg(isXNext)
        return True
    if boardFull(b):
        print("DRAW Game Over")
        return True
    return False

# Main progam 
isXNext = askWhoStarts()
b = createBoard()
finished = False
printBoard(b)    
while not finished:
    pos = getValidPos(isXNext, b)
    updateBoard(b, pos, isXNext)        
    printBoard(b)
    finished = checkFinished(b, isXNext)
    isXNext = not isXNext
        

