# Date and time abstraction
#   The file contains an outline for the 
#   abstraction suggested in the answer sheet 

# Create a new date and time
def newDateTime(mm, dd, hh, nn):
    if mm < 1 or mm > 12:
        return (False, "Month {} does not exist".format(mm))
    if dd < 1 or dd > days[mm-1]:
        return (False, "Day {} in month {} does not exist".format(dd, mm))
    dayNum = sum(days[0:mm-1]) + dd    
    if hh < 0 or hh > 23:
        return (False, "Hour {} does not exist".format(hh))
    if nn < 0 or nn > 59:
        return (False, "Minute {} does not exist".format(nn))
    return (True, (dayNum, hh*60+nn))

# Create a new date
def newDate(mm,dd):
    valid, rep = newDateTime(mm,dd,0,0)
    if valid:
        return (True, (rep[0], -1))
    return (False, rep) 

# Check if date time is valid and give an error if not
def errorMsg(dt):
    valid, rep = dt
    if valid : return ""
    return rep

# Display in DD/MM, 00:00hrs
def displayShort(dt):
    valid, rep = dt
    if not valid : return ""
    days,mins = rep
    month, dayInMonth = _getDayMonth(days)
    if mins >= 0:
        return "{:0>2}/{:0>2}, {:0>2}:{:0>2}hrs".format(\
            dayInMonth, month, mins // 60, mins % 60)
    else:
        return "{:0>2}/{:0>2}".format(dayInMonth, month)

# Dispay in DD mmmmm, 00:00am
def displayLong(dt):
    valid, rep = dt
    if not valid : return ""
    days,mins = rep
    m, dayInMonth = _getDayMonth(days)
    if mins >= 0:
        return "{} {}, ".format(months[m-1], dayInMonth) + _get12HrMin(mins)
    else:
        return "{} {}".format(months[m-1], dayInMonth)
               
# Return interval by which dt2 is after dt1
def between(dt1, dt2):
    v1, r1 = dt1
    v2, r2 = dt2
    if not v1 or not v2 : return 0
    d1,m1 = r1
    d2,m2 = r2
    diff = (d2*1440+m2) - (d1*1440+m1)
    if diff == 0: return "Same time"
    ab = "after"
    if diff < 0 :
        ab = "before"
        diff = - diff
    d = diff // 1440
    h = (diff - d * 1440) // 60
    m = diff  - d * 1440 - h * 60
    return "{}:{:0>2}:{:0>2} {}".format(d,h,m,ab)

# ------- Internal functions -------------

months = ["January", "February", "March", "April", "May", "June", \
          "July", "August", "September", "October", "November", "December"]
days = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]

def _getDayMonth(numDays):
    month = 0
    cumul = 0
    while cumul + days[month] < numDays:
        cumul = cumul + days[month]
        month = month + 1
    return (month + 1, numDays-cumul)

# https://en.wikipedia.org/wiki/12-hour_clock
# 12:00 midhnight -> 12:01am -> 12:59am -> 1:00am -> 11:59am -> 12:00 noon (midday)
# Midday 12:00 noon -> 12:59pm -> 1:00pm -> 11:59pm -> 12:00am (midnight)
def _get12HrMin(numMins):
    h = numMins // 60
    m = numMins % 60
    if h==0 and m==0: return "12:00 midnight"
    if h==12 and m==0: return "12:00 noon"
    ampm = "am"
    if h > 11 : ampm = "pm"
    if h > 12 : h = h - 12
    if h == 0 : h = 12
    return "{:0>2}:{:0>2}".format(h,m) + ampm
    
# ------- Test cases -------------
dt1 = newDateTime(1,1,0,0)
print(errorMsg(dt1), displayShort(dt1), "is", displayLong(dt1))
dt2 = newDateTime(1,1,0,1)
print(errorMsg(dt2), displayShort(dt2), "is", displayLong(dt2))
dt3 = newDateTime(1,31,0,1)
print(errorMsg(dt3), displayShort(dt3), "is", displayLong(dt3))
dt4 = newDateTime(2,1,0,1)
print(errorMsg(dt4), displayShort(dt4), "is", displayLong(dt4))
dt5 = newDateTime(2,1,12,59)
print(errorMsg(dt5), displayShort(dt5), "is", displayLong(dt5))
print(displayShort(dt1),"and",displayShort(dt2), "gives", between(dt1, dt2))
print(displayShort(dt1),"and",displayShort(dt4), "gives", between(dt1, dt4))
print(displayShort(dt5),"and",displayShort(dt1), "gives", between(dt5, dt1))
print(displayShort(dt4),"and",displayShort(dt4), "gives", between(dt4, dt4))

dt6 = newDateTime(3,3,12,0)
print(errorMsg(dt1), displayShort(dt6), "is", displayLong(dt6))
dt7 = newDateTime(4,1,23,59)
print(errorMsg(dt2), displayShort(dt7), "is", displayLong(dt7))
dt8 = newDateTime(5,31,13,30)
print(errorMsg(dt3), displayShort(dt8), "is", displayLong(dt8))

dt9 = newDate(3,3)
print(errorMsg(dt9), displayShort(dt9), "is", displayLong(dt9))
dt10 = newDate(4,1)
print(errorMsg(dt10), displayShort(dt10), "is", displayLong(dt10))
dt11 = newDate(5,31)
print(errorMsg(dt11), displayShort(dt11), "is", displayLong(dt11))

dt71 = newDateTime(1,1,0,60)
print(errorMsg(dt71), displayShort(dt71), "is", displayLong(dt71))
dt72 = newDateTime(2,29,0,1)
print(errorMsg(dt72), displayShort(dt72), "is", displayLong(dt72))
dt73 = newDateTime(1,31,25,1)
print(errorMsg(dt73), displayShort(dt73), "is", displayLong(dt73))
