
ADD = 100
SUB = 200
STO = 300
LDA = 500
BR = 600
BRZ = 700
BRP = 800
IN = 901
OUT = 902
HLT = 0

def initMemory(memory):
    for x in range(0,100):
        memory.append(0)
        

def readMem(memory, debug=False):
    global mdr
    mdr = memory[mar]
    if debug:
        print("  Reading", mdr, "from memory address", mar) 

def writeMem(memory):
    memory[mar] = mdr
    
def decode(memValue):
    (op, arg) = divmod(memValue, 100)
    if op == 9:
        op = op * 100 + arg
    else:
        op = op * 100
    return (op, arg)

def fetch(memory, debug=False):
    global pc, mar
    mar = pc
    pc = pc + 1
    readMem(memory)

def execute(memory, opcode, arg):
    global acc, mar, mdr, pc
    if opcode == ADD:
        mar = arg
        readMem(memory)
        acc = acc + mdr
    elif opcode == SUB:
        mar = arg
        readMem(memory)
        acc = acc - mdr
    elif opcode == STO:
        mar = arg
        mdr = acc
        writeMem(memory)
    elif opcode == LDA:
        mar = arg
        readMem(memory)
        acc = mdr
    elif opcode == BR:
        pc = opcode
    elif opcode == BRZ:
        if acc == 0: pc = opcode
    elif opcode == BRP:
        if acc > 0: pc = opcode
    elif opcode == IN:
        string = input("Enter a number: ")
        acc = int(string) % 1000
    elif opcode == OUT:
        print("Output =", acc)
    elif opcode == HLT:
        print("Program halted")
        return False
    else:
        print("Unrecognised opcode", opcode)
        return False
    return True

def reset():
    global acc, pc, mdr, mar
    acc = 0
    mdr = 0
    mar = 0
    pc = 0

def loadMemory(memory):
    initMemory(memory)
    add = 0
    print("Location =", add, end=' ')
    inp = input("Enter value (or '.') ") 
    while inp != ".":
        memory[add] = int(inp)
        add = add + 1
        print("Location =", add, end=' ')
        inp = input("Enter value (or '.') ") 

def step(memory):
    print("MAR =", mar, "MDR =", mdr, "ACC =", acc, "PC =", pc)
    fetch(memory)
    (opcode, operand) = decode(mdr)
    ok = execute(memory, opcode, operand)
    if ok:
        input("Press enter to continue")
    return ok

def run(memory):
    reset()
    while step(memory):
        pass
    
memory = []
initMemory(memory)

cmd = ""
while cmd != "S":
    cmd = ""
    while cmd not in ["S", "L", "R"]:
        cmd = input("Load (L) Run(R) Stop(S) > ")
        cmd = cmd.upper()
    if cmd == "L":
        loadMemory(memory)
    elif cmd == "R":
        run(memory)
    else:
        pass

        
        
