public class StatementTest {

    static String getText(Statement st) {
	return st.getEntire().getText();
    }

    static String getStripped(Statement st) {
	return st.getStripped().getText();
    }

    static String getLabel(Statement st) {
	return st.getLabel().getText();
    }

    static String getMnemonic(Statement st) {
	return st.getMnemonic().getText();
    }

    static String getOperand(Statement st) {
	if (st == null) {
	    System.out.println("st is null");
	}
	Token operand = st.getOperand();
	if (operand == null) {
	    System.out.println("operand is null");
	}
	return st.getOperand().getText();
    }

    static String getJunk(Statement st) {
	return st.getJunk().getText();
    }

    static int getTextStart(Statement st) {
	return st.getEntire().getStart();
    }

    static int getStrippedStart(Statement st) {
	return st.getStripped().getStart();
    }

    static int getLabelStart(Statement st) {
	return st.getLabel().getStart();
    }

    static int getMnemonicStart(Statement st) {
	return st.getMnemonic().getStart();
    }

    static int getOperandStart(Statement st) {
	return st.getOperand().getStart();
    }

    static int getJunkStart(Statement st) {
	return st.getJunk().getStart();
    }

    static int getTextEnd(Statement st) {
	return st.getEntire().getEnd();
    }

    static int getStrippedEnd(Statement st) {
	return st.getStripped().getEnd();
    }

    static int getLabelEnd(Statement st) {
	return st.getLabel().getEnd();
    }

    static int getMnemonicEnd(Statement st) {
	return st.getMnemonic().getEnd();
    }

    static int getOperandEnd(Statement st) {
	return st.getOperand().getEnd();
    }

    static int getJunkEnd(Statement st) {
	return st.getJunk().getEnd();
    }

    public static Statement testLine(String ln) {
	System.out.println("Line          = " + ln + ".");
	Statement st = new Statement(ln, 0);
	System.out.println("Text          = " + getText(st) + ".");
	System.out.println("Statement     = " + getStripped(st) + ".");
	System.out.println("Label         = " + getLabel(st) + ".");
	System.out.println("Mnemonic      = " + getMnemonic(st) + ".");
	System.out.println("Operand       = " + getOperand(st) + ".");
	System.out.println("Junk          = " + getJunk(st) + ".");
	System.out.println();
	return st;
    }

    public static void testLineFull(String ln) {
	Statement st = testLine(ln);
	System.out.println("Text Start      = " + getTextStart(st) + ".");
	System.out.println("Text End        = " + getTextEnd(st) + ".");
	System.out.println("Statement Start = " + getStrippedStart(st) + ".");
	System.out.println("Statement End   = " + getStrippedEnd(st) + ".");
	System.out.println("Label Start     = " + getLabelStart(st) + ".");
	System.out.println("Label End       = " + getLabelEnd(st) + ".");
	System.out.println("Mnemonic Start  = " + getMnemonicStart(st) + ".");
	System.out.println("Mnemonic End    = " + getMnemonicEnd(st) + ".");
	System.out.println("Operand Start   = " + getOperandStart(st) + ".");
	System.out.println("Operand End     = " + getOperandEnd(st) + ".");
	System.out.println("Junk Start      = " + getJunkStart(st) + ".");
	System.out.println("Junk End        = " + getJunkEnd(st) + ".");
	System.out.println();
    }

    public static void main(String[] args) {
	testLine("");
	testLine("LABEL");
	testLine("  MNEMONIC");
	testLine("LABEL  MNEMONIC");
	testLine("  MNEMONIC  OPERAND");
	testLine("LABEL  MNEMONIC  OPERAND");
	testLine("  MNEMONIC  OPERAND  JUNK");
	testLine("LABEL  MNEMONIC  OPERAND  JUNK");
	testLine("  MNEMONIC  OPERAND  JUNK  MORE JUNK");
	testLine("LABEL  MNEMONIC  OPERAND  JUNK  MORE JUNK");
	testLine("# COMMENT  ");
	testLine("LABEL  # COMMENT");
	testLine("  MNEMONIC  # COMMENT");
	testLine("LABEL  MNEMONIC  # COMMENT");
	testLine("  MNEMONIC  OPERAND  # COMMENT");
	testLine("LABEL  MNEMONIC  OPERAND  # COMMENT");
	testLine("  MNEMONIC  OPERAND  JUNK  # COMMENT");
	testLine("LABEL  MNEMONIC  OPERAND  JUNK  # COMMENT");
	testLine("  MNEMONIC  OPERAND  JUNK  MORE JUNK  # COMMENT");
	testLineFull("LABEL  MNEMONIC  OPERAND  JUNK  MORE JUNK  # COMMENT");
    }

}

