import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class RunnerTest
extends JFrame {

    Runner runner;
    int stepCount;
    JTextField stepCountField;
    int updateCount;
    JTextField updateCountField;
    JButton inputDoneButton;

    public class TestRunnee
    implements RunneeWithInput {
	Runner.Controller controller = null;
	public void doStep() {
	    stepCount++;
	    if (stepCount%100 == 0) {
		controller.hold();
		inputDoneButton.setEnabled(true);
	    }
	}
	public void setRunnerController(Runner.Controller rc) {
	    controller = rc;
	}
	public void inputDone() {
	    inputDoneButton.setEnabled(false);
	    controller.resume();
	}
    }

    public RunnerTest() {

	stepCount = 0;
	stepCountField = new JTextField(8);
	stepCountField.setText("0");
	stepCountField.setBorder(
		BorderFactory.createTitledBorder("Steps"));

	updateCount = 0;
	updateCountField = new JTextField(8);
	updateCountField.setText("0");
	updateCountField.setBorder(
		BorderFactory.createTitledBorder("Updates"));

	JPanel runneePanel = new JPanel(new GridLayout(3, 1));
	runneePanel.add(stepCountField);
	runneePanel.add(updateCountField);

	RunUpdater updater = new RunUpdater() {
	    public void update() {
		updateCount++;
		stepCountField.setText(Integer.toString(stepCount));
		updateCountField.setText(Integer.toString(updateCount));
	    }
	};

	final TestRunnee runnee = new TestRunnee();
	runner = new Runner(runnee, updater);

	inputDoneButton = new JButton("Input");
	inputDoneButton.setEnabled(false);
	inputDoneButton.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		runnee.inputDone();
	    }
	});
	runneePanel.add(inputDoneButton);

	Container contentPane = getContentPane();
	contentPane.setLayout(new FlowLayout());
	contentPane.add(runner.getControlPanel());
	contentPane.add(runneePanel);

	addWindowListener(new WindowAdapter() {
	    public void windowClosing(WindowEvent e) {
		dispose();
		System.exit(0);
	    }
	});

	runner.setEnabled(true);

    }  // public RunnerTest()

    public static void main(String[] args) {
	RunnerTest test = new RunnerTest();
	test.pack();
	test.setLocation(100, 100);
	test.show();
    }  // public static void main(String[])

}  // public class RunnerTest

