import java.io.*;
import java.util.*;

public class ProgramTest {

    static String getText(Statement st) {
	return st.getEntire().getText();
    }

    static String getStripped(Statement st) {
	return st.getStripped().getText();
    }

    static String getLabel(Statement st) {
	return st.getLabel().getText();
    }

    static String getMnemonic(Statement st) {
	return st.getMnemonic().getText();
    }

    static String getOperand(Statement st) {
	if (st == null) {
	    System.out.println("st is null");
	}
	Token operand = st.getOperand();
	if (operand == null) {
	    System.out.println("operand is null");
	}
	return st.getOperand().getText();
    }

    static String getJunk(Statement st) {
	return st.getJunk().getText();
    }

    static int getTextStart(Statement st) {
	return st.getEntire().getStart();
    }

    static int getStrippedStart(Statement st) {
	return st.getStripped().getStart();
    }

    static int getLabelStart(Statement st) {
	return st.getLabel().getStart();
    }

    static int getMnemonicStart(Statement st) {
	return st.getMnemonic().getStart();
    }

    static int getOperandStart(Statement st) {
	return st.getOperand().getStart();
    }

    static int getJunkStart(Statement st) {
	return st.getJunk().getStart();
    }

    static int getTextEnd(Statement st) {
	return st.getEntire().getEnd();
    }

    static int getStrippedEnd(Statement st) {
	return st.getStripped().getEnd();
    }

    static int getLabelEnd(Statement st) {
	return st.getLabel().getEnd();
    }

    static int getMnemonicEnd(Statement st) {
	return st.getMnemonic().getEnd();
    }

    static int getOperandEnd(Statement st) {
	return st.getOperand().getEnd();
    }

    static int getJunkEnd(Statement st) {
	return st.getJunk().getEnd();
    }

    public static void testStatement(Statement st) {
	System.out.println("Line          = " + getText(st) + ".");
	System.out.println("Text          = " + getText(st) + ".");
	System.out.println("Statement     = " + getStripped(st) + ".");
	System.out.println("Label         = " + getLabel(st) + ".");
	System.out.println("Mnemonic      = " + getMnemonic(st) + ".");
	System.out.println("Operand       = " + getOperand(st) + ".");
	System.out.println("Junk          = " + getJunk(st) + ".");
	System.out.println();
    }

    public static void printPositions(Statement st) {
	System.out.println("Text Start      = " + getTextStart(st) + ".");
	System.out.println("Text End        = " + getTextEnd(st) + ".");
	System.out.println("Statement Start = " + getStrippedStart(st) + ".");
	System.out.println("Statement End   = " + getStrippedEnd(st) + ".");
	System.out.println("Label Start     = " + getLabelStart(st) + ".");
	System.out.println("Label End       = " + getLabelEnd(st) + ".");
	System.out.println("Mnemonic Start  = " + getMnemonicStart(st) + ".");
	System.out.println("Mnemonic End    = " + getMnemonicEnd(st) + ".");
	System.out.println("Operand Start   = " + getOperandStart(st) + ".");
	System.out.println("Operand End     = " + getOperandEnd(st) + ".");
	System.out.println("Junk Start      = " + getJunkStart(st) + ".");
	System.out.println("Junk End        = " + getJunkEnd(st) + ".");
	System.out.println();
    }

    public static String readText(File f)
    throws IOException {
	StringBuffer textBuffer = new StringBuffer();
	Reader reader = new FileReader(f);
	BufferedReader bufferedReader = new BufferedReader(reader);
	String str = bufferedReader.readLine();
	while (str != null) {
	    str += "\n";
	    textBuffer.append(str);
	    str = bufferedReader.readLine();
	}
	bufferedReader.close();
	return textBuffer.toString();
    }

    public static void main(String[] args) {
	Program program = new Program();
	try {
	    program.setText(readText(new File("ProgramTest.in")));
	} catch(IOException e) {
	    System.err.println(e.getMessage());
	    System.exit(1);
	}
	Iterator statements = program.getStatements();
	Statement statement = null;
	while (statements.hasNext()) {
	    statement = (Statement)statements.next();
	    testStatement(statement);
	}
	printPositions(statement);
    }

}

