import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public abstract class LMCElement {

    protected JInternalFrame frame;

    protected abstract Action[] createToolBarActions();

    protected abstract JComponent createVisual();

    public LMCElement() {
	frame = new JInternalFrame();
	frame.getContentPane().setLayout(new BorderLayout());
	Action[] toolBarActions = createToolBarActions();
	if (toolBarActions != null) {
	    JToolBar toolBar = new JToolBar();
	    for (int i = 0; i < toolBarActions.length; i++) {
		toolBar.add(toolBarActions[i]);
	    }
	    frame.getContentPane().add(toolBar, BorderLayout.NORTH);
	}
	frame.getContentPane().add(createVisual(), BorderLayout.CENTER);
	frame.pack();
	frame.setVisible(true);
    }

    public JInternalFrame getFrame() {
	return frame;
    }

}

