import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class LMC
extends JApplet {

    public static final String TITLE = "LMC Editor/Assembler/Simulator";
    public static final String VERSION = "v1.2";
    public static final Font font = new Font("Monospaced", Font.PLAIN, 12);

    private static CPU cpu;
    private static IO io;
    private static Memory memory;
    private static Editor editor;
    private static Assembler assembler;
    private static Computer computer;

    private static boolean application;

    private static void addLMCPane(Container c) {
	cpu = new CPU();
	io = new IO();
	memory = new Memory();
	editor = new Editor();
	assembler = new Assembler();
	computer = new Computer();
	Dimension eDim = LMC.getEditor().getFrame().getSize();
	Dimension pDim = LMC.getComputer().getFrame().getSize();
	JDesktopPane desktopPane = new JDesktopPane();
	Dimension dDim = new Dimension(eDim.width + pDim.width + 20,
		eDim.height + 10);
	desktopPane.setPreferredSize(dDim);
	desktopPane.add(editor.getFrame());
	desktopPane.add(assembler.getFrame());
	desktopPane.add(computer.getFrame());
	c.setLayout(new BorderLayout());
	c.add(desktopPane, BorderLayout.CENTER);
    }

    public void start() {
	application = false;
	addLMCPane(getContentPane());
    }

    public static boolean isApplication() {
	return application;
    }

    public static CPU getCPU() {
	return cpu;
    }

    public static IO getIO() {
	return io;
    }

    public static Memory getMemory() {
	return memory;
    }

    public static Editor getEditor() {
	return editor;
    }

    public static Assembler getAssembler() {
	return assembler;
    }

    public static Computer getComputer() {
	return computer;
    }

    public static void main(String[] args) {
	application = true;
	final JFrame frame = new JFrame(TITLE + " " + VERSION);
	frame.addWindowListener(new WindowAdapter() {
	    public void windowClosing(WindowEvent e) {
		if (LMC.getEditor().checkIfModified()) {
		    frame.dispose();
		    System.exit(0);
		}
	    }
	});
	addLMCPane(frame.getContentPane());
	frame.pack();
	frame.setLocation(100, 100);
	frame.show();
    }

}

