import java.util.*;

public abstract class Instruction
implements Comparable {

    private String mnemonic;
    private String description;
    private int opcode;
    private int operandSize;

    private static Map instructionSet = new HashMap();
    private static Instruction[] all = null;
    
    public Instruction(String mne, String desc, int opc, int opndSz) {
	mnemonic = mne;
	description = desc;
	opcode = opc;
	operandSize = opndSz;
	instructionSet.put(mne, this);
    }

    public String getMnemonic() {
	return mnemonic;
    }

    public String getDescription() {
	return description;
    }

    public int getOpcode() {
	return opcode;
    }

    public int getOperandSize() {
	return operandSize;
    }

    public int compareTo(Object o)
    throws ClassCastException {
	Instruction ins = (Instruction)o;
	return mnemonic.compareTo(ins.getMnemonic());
    }

    public boolean equals(Object o) {
	if (o == null) {
	    return false;
	}
	Instruction ins = null;
	try {
	    ins = (Instruction)o;
	} catch(ClassCastException e) {
	    return false;
	}
	return mnemonic.equals(ins.getMnemonic());
    }

    public int hashCode() {
	return mnemonic.hashCode();
    }

    public abstract void execute(int opnd);

    public static Instruction get(String mne) {
	return (Instruction)instructionSet.get(mne);
    }

    public static Instruction[] getAll() {
	if (all == null) {
	    all = (Instruction[])instructionSet.values().toArray();
	    Arrays.sort(all);
	}
	return all;
    }

}

