from Entry import *
from BinTree import *

def printInOrder(p):
    if p.left != None:
        printInOrder(p.left)
    print(p.value, end=" ")
    if p.right != None:
        printInOrder(p.right)


def printPreOrder(n, p):
    print("  " * n, p.value)
    if p.left != None:
        printPreOrder(n+1, p.left)
    if p.right != None:
        printPreOrder(n+1, p.right)

def printPostOrder(n, p):
    if p.left != None:
        printPostOrder(n+1, p.left)
    if p.right != None:
        printPostOrder(n+1, p.right)
    print("  " * n, p.value)
        
t = BinTree()
t.addItem(37)
t.addItem(21)
t.addItem(57)
t.addItem(27)
t.addItem(67)
t.addItem(7)

print("In Order:", end=" ")
printInOrder(t.root)
print("")

print("\nPre Order, Indented")
printPreOrder(0, t.root)

print("\nPost Order, Indented")
printPostOrder(0, t.root)
