import random

MINEVALUE = -2
MINECLEAR = -1
SIZE = 4

def makeMineField():
    mines = []
    for x in range(0, SIZE):
        m = []
        for y in range(0, SIZE):
            if random.random() > 0.9:
                m.append(MINEVALUE)
            else:
                m.append(MINECLEAR)
        mines.append(m)
        
##    mines = [[-1,-1,-2,-1],[-1,-2,-1,-1],[-1,-1,-2,-2],[-1,-1,-1,-1]]
    return mines

def printMines(mines, detects):
    row = 0
    print("    0 1 2 3")
    print("    -------")
    for ms in mines:
        line = " " + str(row) + ": "
        col = 0
        for m in ms:
            if (col, row) in detects:
                line = line + "M "
            elif m < 0:
                line = line + "* "
            else:
                line = line + str(m) + " "
            col = col + 1
        print(line)
        row = row + 1

##This function shows the mine field as follows:
##   - clear cells                 .
##   - uncleared cells             *
##   - correctly detected mines    m
##   - undetected mines            M
##   - incorrect mines             x
def showMines(mines, detects):
    row = 0
    complete = True
    print("    0 1 2 3")
    print("    -------")
    for ms in mines:
        col = 0
        line = " " + str(row) + ": "
        for m in ms:
            if m == MINEVALUE and (col, row) in detects:
                line = line + "m "
            elif m == MINEVALUE:
                line = line + "M "
                complete = False
            elif m >= 0:
                line = line + ". "
            elif (col, row) in detects:
                line = line + "x "
                complete = False
            else:
                line = line + "* "
                complete = False
            col = col + 1
        print(line)
        row = row + 1
    return complete

def scoreNeighbours(mines, c, r):
    sum = 0
    sum = sum + scoreCell(mines, c-1, r-1)
    sum = sum + scoreCell(mines, c-1, r)
    sum = sum + scoreCell(mines, c-1, r+1)
    sum = sum + scoreCell(mines, c, r-1)
    sum = sum + scoreCell(mines, c, r+1)
    sum = sum + scoreCell(mines, c+1, r-1)
    sum = sum + scoreCell(mines, c+1, r)
    sum = sum + scoreCell(mines, c+1, r+1)
    return sum

def scoreCell(mines, c, r):
    if r < 0 or r >= len(mines):
        return 0
    m = mines[r]
    if c < 0 or c >= len(m):
        return 0
    if m[c] == MINEVALUE:
        return 1
    return 0


def turn(mines, detects):
    dt = ""
    while dt not in ['D', 'T']:
        dt = input("Detect(D) or Test(T)? ")
    
    col = int(input("Which column> "))
    row = int(input("Which row> "))

    if dt == 'T':
        if mines[row][col] == MINEVALUE:
            print("B O O O O M")
            return False

        mines[row][col] = scoreNeighbours(mines, col, row)
        return True
    else:
        detects.append((col,row))
        return True
    
ms = makeMineField()
detects = []
turnNum = 0

##showMines(ms, detects)
alive = True
while alive and turnNum < SIZE * SIZE:
    printMines(ms, detects)
    alive = turn(ms, detects)
    turnNum = turnNum + 1
    
if showMines(ms, detects):
    print("Well done")
else:
    print("Try again!")
