import random

def swap(lst, i, j, debug=False):
    global count
    if debug:
        print("  "*(debug+1), "Swapping", lst[i], "and", lst[j])
    tmp = lst[i]
    lst[i] = lst[j]
    lst[j] = tmp
    count += 1

## Insert sort
def insertSort(lst, debug=False):
    theLen = len(lst)
    indx = 1
    while indx < theLen:
        ## insert the item at index idx
        ## array ordered from 0 to indx - 1
        sindx = indx
        if debug:
            print(lst)
            print("Inserting", lst[indx])
        while sindx > 0 and lst[sindx-1] > lst[sindx]:
            swap(lst, sindx-1, sindx, debug)
            sindx = sindx - 1
        indx = indx + 1

## Bubble sort
def bubbleSort(lst, debug=False):
    theLen = len(lst)
    swapped = True
    if debug:
        passes = 0
 
    while swapped:
        if debug:
            passes = passes + 1
            print("Pass:", passes, lst)
        swapped = False
        indx = 1
        while indx < theLen:
            if lst[indx-1] > lst[indx]:
                
                swap(lst, indx-1, indx, debug)
                swapped = True
            indx = indx + 1

## Quick sort
def quickSort(lst, debug=False):
    quickSort1(lst, 0, len(lst)-1, debug)

def quickSort1(lst, i, j, debug):
    if debug: print("  "*debug, "Sorting:", lst[i:j+1])
    if j - i > 0:
        k = partition(lst, i, j, debug)
        if debug:
            debug1 = debug + 1
        else:
            debug1 = debug
        quickSort1(lst, i, k-1, debug1)
        quickSort1(lst, k+1, j, debug1)
    if debug: print("  "*debug, "Sorted:", lst[i:j+1])

def partition(lst, l, r, debug):
    pivot = lst[l]
    if debug: print("  "*debug, "Pivot value is", pivot)
    idx = l+1
    ix_gte = l+1
    while idx <= r:
        if lst[idx] < pivot:
            swap(lst, idx, ix_gte, debug)
            ix_gte = ix_gte+1
        idx = idx + 1
    swap(lst, l, ix_gte-1, debug)
    return ix_gte-1
    
    
    
## Main program
##
##  1. Choose sorting algorithm
##  2. Choose to trial or debug
##  3. Choose list length


def runTrials(lstLen, debug=False, log=False):
    global count
    trial = 0
    total = 0
    while trial < trials:
        myLst = []
        l = 0
        while l < lstLen:
            myLst.append(random.randint(0, 99))
            l = l + 1

        count = 0
        sort(myLst, debug)

        if log:
            print("List length", lstLen, "sorted in", count, "steps")
        trial = trial + 1
        total = total + count
    return total


count = 0
sortName = 'X'
while sortName not in ['I', 'B', 'Q']:
    sortName = input("Available sort algorithm:\n  B - bubble\n  I - insert\n  Q - quick\nEnter choice>")

if sortName=='B':
    sort = bubbleSort
    print("Testing the Bubble Sort Algorithm")
if sortName=='I':
    sort = insertSort
    print("Testing the Insertion Sort Algorithm")
if sortName=='Q':
    sort = quickSort
    print("Testing the QuickSort Algorithm")

trialDT = 'X'
while trialDT not in ['D', 'T', 'M']:
   trialDT = input("Do you want to Demo(D), Trial(T), Multi-trial(M)> ")
if trialDT == 'D':
    trials = 1
    debug = True
else:
    trials = 30
    debug = False

if trialDT != 'M':
    lstLen = int(input("Enter list length> "))
    total = runTrials(lstLen, debug, True)
    if trials > 1:
        print("List length", lstLen, "sorted in average of", total/trials, "swap")
else:
    for l in [50, 100, 150, 200, 250, 300, 350, 400]:
        total = runTrials(l)
        print("List length", l, "sorted in average of {:.1f} swaps".format(total/trials))
        
    
    
