# This is the obvious recursive imlementation
# It is VERY slow, requiring O(2**n) steps
def fibS(n):
    if n==0:return 0
    if n==1: return 1
    return fibS(n-1) + fibS(n-2)

# This recursive implemetation is much quicker
def fib2(n):
    if n==0:return (0, 0)
    if n==1: return (1,0)
    fn1, fn2 = fib2(n-1)
    return (fn1+fn2, fn1)

def fibQ(n):
    return fib2(n)[0]
    
# This is an iterative implemetation
def fibI(n):
    if n == 0: return 0
    i = 1
    f1 = 0   # fib i-1
    f2 = 1   # fib i
    while i < n:
        tmp = f2
        f2 = f2 + f1
        f1 = tmp
        i = i + 1
    return f2
